VehicleCombat = { 
    description = "VehicleCombat"
}

function VehicleCombat:new()

	--[[
	Motorcycle_HP_Multiplier = 1
	Car_HP_Multiplier = 1
	]]--

	--Enable this bad boy
	TweakDB:SetFlat("player.vehicle.canEnterDriverCombat", true)
	
	--Fix little camera bug
	TweakDB:SetFlat("fppCameraParamSets.DriverCombat.yawMaxLeft", 160)
	TweakDB:SetFlat("fppCameraParamSets.DriverCombat.yawMaxRight", -160)

	--Make the two camera states closer
	
	TweakDB:SetFlat("Vehicle.VehicleDriverFPPCameraParamsDefault.is_forward_offset", 1)
	TweakDB:SetFlat("Vehicle.VehicleDriverFPPCameraParamsDefault.lookat_offset_vertical", .05)

	--Let you use all weapons when in vehicles
	TweakDB:SetFlat("GameplayRestriction.OneHandedFirearms.gameplayTags", {"GameplayRestriction"})
	
	--Adjust motorcycle cameras for better melee
	TweakDB:SetFlat("Vehicle.MotorcycleDriverCombatFPPCameraParamsDefault.lookat_yaw_left_offset", 1)
	TweakDB:SetFlat("Vehicle.MotorcycleDriverCombatFPPCameraParamsDefault.lookat_yaw_left_up_offset", 0.3)
	TweakDB:SetFlat("Vehicle.MotorcycleDriverCombatFPPCameraParamsDefault.lookat_yaw_right_offset", 1)
	TweakDB:SetFlat("Vehicle.MotorcycleDriverCombatFPPCameraParamsDefault.lookat_yaw_right_up_offset", 0.3)
	
	--Adjust car camera for better melee
	TweakDB:SetFlat("Vehicle.VehicleDriverCombatFPPCameraParamsDefault.lookat_yaw_left_offset", 1)
	TweakDB:SetFlat("Vehicle.VehicleDriverCombatFPPCameraParamsDefault.lookat_yaw_left_up_offset", 0.17)
	
	--Disable first person auto rotation
	
	--Cars
	TweakDB:SetFlat("fppCameraParamSets.Vehicle.headingResetSpeed", 0)
	
	--Bikes
	TweakDB:SetFlat("fppCameraParamSets.Bike.headingResetSpeed", 0)
	

	--Set HP of each vehicle
	
	--Make the stats
	createConstantStatModifier("archbikehp", "Additive", "BaseStats.Health", 50 * Motorcycle_HP_Multiplier)
	createConstantStatModifier("archhellahp", "Additive", "BaseStats.Health", 65 * Car_HP_Multiplier)
	createConstantStatModifier("archhellapolicehp", "Additive", "BaseStats.Health", 100 * Car_HP_Multiplier)
	createConstantStatModifier("archquartzbandithp", "Additive", "BaseStats.Health", 100 * Car_HP_Multiplier)
	createConstantStatModifier("archquartzhp", "Additive", "BaseStats.Health", 65 * Car_HP_Multiplier)
	createConstantStatModifier("brennanapollohp", "Additive", "BaseStats.Health", 65 * Motorcycle_HP_Multiplier)
	createConstantStatModifier("chevillionemperorhp", "Additive", "BaseStats.Health", 150 * Car_HP_Multiplier)
	createConstantStatModifier("chevillionemperorpolicehp", "Additive", "BaseStats.Health", 225 * Car_HP_Multiplier)
	createConstantStatModifier("colbycx410hp", "Additive", "BaseStats.Health", 100 * Car_HP_Multiplier)
	createConstantStatModifier("colbyhp", "Additive", "BaseStats.Health", 65 * Car_HP_Multiplier)
	createConstantStatModifier("colbylittlemulehp", "Additive", "BaseStats.Health", 125 * Car_HP_Multiplier)
	createConstantStatModifier("herreraoutlawhp", "Additive", "BaseStats.Health", 125 * Car_HP_Multiplier)
	createConstantStatModifier("kusanagihp", "Additive", "BaseStats.Health", 50 * Motorcycle_HP_Multiplier)
	createConstantStatModifier("mahirsupronhp", "Additive", "BaseStats.Health", 100 * Car_HP_Multiplier)
	createConstantStatModifier("shionnomadhp", "Additive", "BaseStats.Health", 125 * Car_HP_Multiplier)
	createConstantStatModifier("shionhp", "Additive", "BaseStats.Health", 75 * Car_HP_Multiplier)
	createConstantStatModifier("porsche911hp", "Additive", "BaseStats.Health", 75 * Car_HP_Multiplier)
	createConstantStatModifier("turbo740hp", "Additive", "BaseStats.Health", 75 * Car_HP_Multiplier)
	createConstantStatModifier("turbovrtechhp", "Additive", "BaseStats.Health", 75 * Car_HP_Multiplier)
	createConstantStatModifier("type66avengerhp", "Additive", "BaseStats.Health", 100 * Car_HP_Multiplier)
	createConstantStatModifier("type66cthulhuhp", "Additive", "BaseStats.Health", 100 * Car_HP_Multiplier)
	createConstantStatModifier("type66javelinahp", "Additive", "BaseStats.Health", 150 * Car_HP_Multiplier)
	createConstantStatModifier("type66stockhp", "Additive", "BaseStats.Health", 75 * Car_HP_Multiplier)
	createConstantStatModifier("aerondighthp", "Additive", "BaseStats.Health", 300 * Car_HP_Multiplier)
	createConstantStatModifier("caliburnhp", "Additive", "BaseStats.Health", 200 * Car_HP_Multiplier)
	createConstantStatModifier("galenageckohp", "Additive", "BaseStats.Health", 100 * Car_HP_Multiplier)
	createConstantStatModifier("galenagthp", "Additive", "BaseStats.Health", 65 * Car_HP_Multiplier)
	createConstantStatModifier("mackinawmtl1hp", "Additive", "BaseStats.Health", 125 * Car_HP_Multiplier)
	createConstantStatModifier("mackinawnomadhp", "Additive", "BaseStats.Health", 200 * Car_HP_Multiplier)
	createConstantStatModifier("thraxjeffersonhp", "Additive", "BaseStats.Health", 100 * Car_HP_Multiplier)
	createConstantStatModifier("villefortalvarradohp", "Additive", "BaseStats.Health", 100 * Car_HP_Multiplier)
	createConstantStatModifier("villefortcolumbushp", "Additive", "BaseStats.Health", 100 * Car_HP_Multiplier)
	createConstantStatModifier("villefortcorteshp", "Additive", "BaseStats.Health", 75 * Car_HP_Multiplier)
	createConstantStatModifier("villefortcortespolice", "Additive", "BaseStats.Health", 125 * Car_HP_Multiplier)
	createConstantStatModifier("delamainhp", "Additive", "BaseStats.Health", 200 * Car_HP_Multiplier)
	createConstantStatModifier("maimaihp", "Additive", "BaseStats.Health", 50 * Car_HP_Multiplier)
	createConstantStatModifier("kaukazhp", "Additive", "BaseStats.Health", 200 * Car_HP_Multiplier)
	createConstantStatModifier("behemothhp", "Additive", "BaseStats.Health", 300 * Car_HP_Multiplier)
	createConstantStatModifier("jackietunedhp", "Additive", "BaseStats.Health", 65 * Motorcycle_HP_Multiplier)
	createConstantStatModifier("beasthp", "Additive", "BaseStats.Health", 200 * Car_HP_Multiplier)

	v_car = "v_car_"
	for _, v in ipairs(TweakDB:GetRecords('gamedataVehicle_Record')) do
		vehicle_identifier = TweakDB:GetFlat(v:GetID()..".player_audio_resource")
		hpstat = ""
		if vehicle_identifier == v_car.."villefort_cortes" then hpstat="villefortcorteshp"
		elseif vehicle_identifier == v_car.."thorton_galena" then hpstat="galenagthp" 
		elseif vehicle_identifier == v_car.."archer_hella" then hpstat="archhellahp"
		elseif vehicle_identifier == v_car.."mizutani_shion_nomad" then hpstat="shionnomadhp"
		elseif vehicle_identifier == "v_mbike_arch_nazare" then hpstat="archbikehp"
		elseif vehicle_identifier == v_car.."chevalier_emperor" then hpstat="chevillionemperorhp"
		elseif vehicle_identifier == v_car.."thorton_colby_nomad" then hpstat="colbylittlemulehp"
		elseif vehicle_identifier == v_car.."villefort_columbus" then hpstat="villefortcolumbushp"
		elseif vehicle_identifier == v_car.."kaukaz_bratsk" then hpstat="kaukazhp"
		elseif vehicle_identifier == v_car.."thorton_mackinaw" then hpstat="mackinawmtl1hp"
		elseif vehicle_identifier == v_car.."porsche_911_turbo" then hpstat="porsche911hp"
		elseif vehicle_identifier == v_car.."quadra_turbo_r_vtek" then hpstat="turbovrtechhp"
		elseif vehicle_identifier == v_car.."villefort_alvarado_cabrio" then hpstat="villefortalvarradohp"
		elseif vehicle_identifier == v_car.."mizutani_shion_tygerclaw" then hpstat="shionhp"
		elseif vehicle_identifier == v_car.."chevalier_thrax" then hpstat="thraxjeffersonhp"
		elseif vehicle_identifier == v_car.."archer_quartz" then hpstat="archquartzbandithp"
		elseif vehicle_identifier == "v_mbike_yaiba_asmx_kusanagi_mizuchi" then hpstat="kusanagihp"
		elseif vehicle_identifier == v_car.."kaukaz_zeya" then hpstat="kaukazhp" 
		elseif vehicle_identifier == v_car.."archer_quartz_gt" then hpstat="archquartzhp"
		elseif vehicle_identifier == v_car.."quadra_type_66" then hpstat="type66stockhp"
		elseif vehicle_identifier == v_car.."thorton_colby" then hpstat="colbyhp"
		elseif vehicle_identifier == v_car.."thorton_colby_pickup" then hpstat="colbycx410hp"
		elseif vehicle_identifier == "v_mbike_yaiba_asmx_kusanagi" then hpstat="kusanagihp"
		elseif vehicle_identifier == "v_mbike_yaiba_asmx_kusanagi_misift" then hpstat="kusanagihp"
		elseif vehicle_identifier == v_car.."thorton_galena_gt" then hpstat="galenagthp"
		elseif vehicle_identifier == v_car.."rayfield_caliburn" then hpstat="caliburnhp"
		elseif vehicle_identifier == v_car.."villefort_alvarado" then hpstat="villefortalvarradohp"
		elseif vehicle_identifier == v_car.."quadra_type_66_nomad" then hpstat="type66javelinahp"
		elseif vehicle_identifier == v_car.."thorton_galena_red" then hpstat="galenagthp"
		elseif vehicle_identifier == v_car.."quadra_turbo_r" then hpstat="turbo740hp"
		elseif vehicle_identifier == v_car.."thorton_colby_aldecaldo" then hpstat="colbylittlemulehp"
		elseif vehicle_identifier == v_car.."archer_quartz_bandit" then hpstat="archquartzbandithp"
		elseif vehicle_identifier == v_car.."villefort_cortes_police" then hpstat="villefortcortespolice"
		elseif vehicle_identifier == "v_mbike_brennan_cycles_apollo" then hpstat="brennanapollohp"
		elseif vehicle_identifier == v_car.."quadra_type_66_rogue" then hpstat="type66avengerhp"
		elseif vehicle_identifier == v_car.."makigai_maimai" then hpstat="maimaihp"
		elseif vehicle_identifier == v_car.."thorton_mackinaw_nomad" then hpstat="mackinawnomadhp"
		elseif vehicle_identifier == v_car.."chevalier_emperor_police" then hpstat="chevillionemperorpolicehp"
		elseif vehicle_identifier == v_car.."rayfield_aerondight" then hpstat="aerondighthp"
		elseif vehicle_identifier == v_car.."thorton_galena_nomad" then hpstat="galenageckohp" 
		elseif vehicle_identifier == v_car.."mahir_supron" then hpstat="mahirsupronhp"
		elseif vehicle_identifier == v_car.."quadra_type_66_ncu" then hpstat="type66cthulhuhp" 
		elseif vehicle_identifier == "v_mbike_brennan_cycles_thanatos" then hpstat="brennanapollohp"
		elseif vehicle_identifier == v_car.."quadra_type_66_avenger" then hpstat="type66avengerhp"
		elseif vehicle_identifier == "v_mbike_arch_nazare_chopper" then hpstat="archbikehp"
		elseif vehicle_identifier == v_car.."archer_hella_police" then hpstat="archhellapolicehp"
		elseif vehicle_identifier == v_car.."thorton_galena_ncu" then hpstat="galenagthp"
		elseif vehicle_identifier == v_car.."mizutani_shion_targa" then hpstat="shionhp"
		elseif vehicle_identifier == v_car.."militech_atilla" then hpstat="behemothhp"
		elseif vehicle_identifier == v_car.."mizutani_shion" then hpstat="shionhp"
		elseif vehicle_identifier == v_car.."yaiba_asmx_kusanagi_secondary" then hpstat="kusanagihp" 
		elseif vehicle_identifier == "v_mbike_brennan_cycles_apollo_sport" then hpstat="brennanapollohp"
		elseif vehicle_identifier == v_car.."herrera_outlaw" then hpstat="herreraoutlawhp"
		elseif vehicle_identifier == v_car.."kaukaz_bratsk_missle" then hpstat="kaukazhp"
		elseif vehicle_identifier == v_car.."archer_quartz_nomad" then hpstat="archquartzbandithp"
		elseif vehicle_identifier == v_car.."thorton_galena_sq011" then hpstat="galenagthp" 
		elseif vehicle_identifier == v_car.."thorton_mackinaw_nomad_alt" then hpstat="mackinawnomadhp"
		elseif vehicle_identifier == v_car.."archer_hella_jacky" then hpstat="archhellahp"
		elseif vehicle_identifier == v_car.."brennan_cycles_apollo_hellhound" then hpstat="brennanapollohp"
		elseif vehicle_identifier == v_car.."thorton_galena_q204" then hpstat="galenagthp"
		end
		if hpstat == "" then
			--print(tostring(v:GetID()))
		else
			createVehicleStats(v:GetID(), vehicle_identifier, hpstat)
		end
	end
	
	--Delamain special case
	TweakDB:SetFlat("Vehicle.v_standard2_villefort_cortes_delamain.statModifiers", {"delamainhp"})
	TweakDB:SetFlat("Vehicle.v_standard2_villefort_cortes_delamain_player.statModifiers", {"delamainhp"})
	
	--Make vehicles use player drive data
	for i,v in ipairs(TweakDB:GetRecords('gamedataVehicle_Record')) do 
		TweakDB:SetFlat(v:GetID()..'.vehDriveModelDataAI', TweakDB:GetFlat(v:GetID()..'.vehDriveModelData'))
	end
	
	
	--Give the police all the object actions (needs to be in here for onInit)
	objectActions_List = TweakDB:GetFlat("Character.arr_sixthstreet_hooligan_melee1_knife_ma.objectActions")
	for i,v in ipairs(TweakDB:GetRecords('gamedataCharacter_Record')) do
		if TweakDB:GetFlat(v:GetID()..'.affiliation') == ToTweakDBID{ hash = 0x84A76558, length = 13 } then

			if TweakDB:GetFlat(v:GetID()..'.audioMeleeMaterial') == ToCName{ hash_lo = 0xFB7B3F4D, hash_hi = 0x0A25000A --[[ Flesh --]] } then
				TweakDB:SetFlat(v:GetID()..'.objectActions', objectActions_List)
			end
		end
	end
	
end

function createVehicleStats(vehicle, vehicle_identifier, hpstat)
	TweakDB:CloneRecord(vehicle_identifier.."Stats", "VehicleStatPreset.BaseCar")
	TweakDB:SetFlat(vehicle_identifier.."Stats.statModifiers", {hpstat, "VehicleStatPreset.BaseCar_inline1", "BaseStats.BaseAudioStimRangeMultiplier", "BaseStats.BaseVisualStimRangeMultiplier"})
	TweakDB:SetFlat(vehicle..'.statModifierGroups', {vehicle_identifier.."Stats"})
end
function createConstantStatModifier(recordName, modifierType, statType, value)
	TweakDB:CreateRecord(recordName, "gamedataConstantStatModifier_Record")
	TweakDB:SetFlat(recordName..".modifierType", modifierType)
	TweakDB:SetFlat(recordName..".statType", statType)
	TweakDB:SetFlat(recordName..".value", value)
end


return VehicleCombat:new()
